﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public partial class Student : StatsBaseComponent
    {
        protected class CompetencePartPanel : StatsPanel
        {
            public CompetencePartPanel(StatsBaseComponent Component) : base(Component) { }

            
            public override void Load()
            {
                if (Component.Student != null && CompetenceID.HasValue)
                {
                    Component.AppendToXML(Component.Student);

                    List<BL.BO.Student> _listStudent = new List<BL.BO.Student>();
                    _listStudent.Add(Component.Student);
                    AppendToXML(_listStudent);

                    // tutaj statystyka dla danej kompetencji glownej, wiec lista zawiera tylko jeden wpis
                    AppendToXML(Component.Student, Component.BLELearning.Statistic.CompetenceStatistic.Restore(Component.Student, CompetenceID));

                    // tutaj lista kompetencji skladowych posumowana dla danej kompetencji glownej wkontekscie studenta
                    // stopnie trudnosci tez sa rozbijane, ale w sumie nie trzeba pokazywac rozbicia na poziomie kompetencji skladowej w kontekscie studenta
                    // tutaj jeszcze chwila zastanowienia
                    AppendToXML(Component.Student, Component.BLELearning.Statistic.CompetencePartStatistic.Restore(Component.Student, CompetenceID));

                    // Lista stopni zaawansowania
                    AppendToXML(Component.BLELearning.AdvancedLevel.Restore());

                    // Lista ocen
                    AppendToXML(Component.BLELearning.EvaluationSheet.Restore());
                }
            }

            public override bool Save()
            {
                return true;
            }
        }
    }
}